package edu.unl.consystlab.sudokuSolver;

import java.awt.Color;
import java.awt.*;
import java.awt.font.FontRenderContext;
import java.awt.geom.*;

public class solCell extends Container
{
	private solBoard parentBoard;
	private String assignedNumber;	
	private int cellWidth;
	private int cellHeight;		
	private Color myBackgroundColor;
	
	
	public solCell(String assignNum, int newCellWidth, int newCellHeight, solBoard newBoard)
	{
		if (assignNum == null) {
			assignedNumber = "0";
		} else {
			assignedNumber = assignNum;
		}		
		
		parentBoard = newBoard;
		
		cellWidth = newCellWidth;
		cellHeight = newCellHeight;
		
		myBackgroundColor = Color.WHITE;			
	}
	
	public void paint(Graphics g)
	{
		//Image offScreen = createImage(this.getWidth(), this.getHeight());
		Point midPoint = new Point(this.getWidth()/2,this.getHeight()/2);

		//String printString = assignedNumber;
		String printString;
		
		printString = assignedNumber;
				
		
		Graphics2D g2= (Graphics2D)g;
		//myBackgroundColor = Color.BLACK;
		//g2.setBackground(myBackgroundColor);
		Color tempColor = g2.getColor();
		Rectangle2D backRectangle = new Rectangle2D.Float(0,0,cellWidth,cellHeight);
		g2.setColor(myBackgroundColor);
		g2.fill(backRectangle);
		g2.setColor(tempColor);
		
		//draw the background		
		//Graphics2D g2 = (Graphics2D)offScreen.getGraphics();
		//antialiasing makes it look much better, but does slow it down.
		//g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		//g2.setFont(new Font("courier", Font.BOLD, 12));
		
		Font originalFont = g2.getFont();
		Stroke originalStroke = g2.getStroke();
		Color originalColor = g2.getColor();
		
		g2.setFont(new Font("Monospaced", Font.PLAIN, 10));
		//make the line thiner
		//it is assumed to be one pixal.
		g2.setStroke(new BasicStroke(0.01f));
		//draw the top line
		g2.drawLine(0,0,cellWidth,0);
		//draw the bottom line
		g2.drawLine(0,cellHeight-1,cellWidth,cellHeight-1);
		//draw the left side
		g2.drawLine(0,0,0,cellHeight);
		//draw the right side
		g2.drawLine(cellWidth-1,0,cellWidth-1,cellHeight);		

		FontRenderContext frc = g2.getFontRenderContext();
		//We want preassignes to look different than ones assigned by
		// the user.
		
		g2.setFont(g2.getFont().deriveFont(15f));		

		//center the text
		Rectangle2D bounds =g2.getFont().getStringBounds(printString, frc);
		float width = (float) bounds.getWidth();
		//we modify the height to be 5/8th the normal height because it appears that
		//is what numbers are in reality.  Letters are similar though not neccesarily
		//the same.
		float height = ((((float)bounds.getHeight())*5)/8);
		g2.drawString(printString, midPoint.x-(width/2)+1, midPoint.y+(height/2));		
		//g.drawImage(offScreen, 0, 0, this);
		g2.setFont(originalFont);
		g2.setStroke(originalStroke);
		g2.setColor(originalColor);

	}	
	
	public void setBackgroundColor(Color newColor)
	{
		myBackgroundColor = newColor;
	}	
	
	
}